/* This script corrects the orientation of images that haven't been rotated properly by some software */

import se.datadosen.jalbum.*;
import se.datadosen.component.*;
import se.datadosen.util.*;
import se.datadosen.util.FileFilters.BasicImageInfo;

int processCount = 0;

void processFolder(AlbumObject folder) {
	for (AlbumObjectImpl ao : folder.getChildren()) {
		if (ao.isFolder()) {
			processFolder(ao);
		}
		else if (ao.getCategory() == Category.image) {
			BasicImageInfo info = ao.getImageInfo();
			if (info.height > info.width && ao.getOrientation() != Orientation.normal) {
				ao.setOrientation(Orientation.normal);
				processCount++;
			}
		}
	}
}

// Execution starts here
msg =
"This script corrects the orientation of images that haven't been rotated properly by some software";
int option = JOptionPane.showConfirmDialog(window, msg, "Correct image orientation", JOptionPane.OK_CANCEL_OPTION, JOptionPane.INFORMATION_MESSAGE);
if (option != JOptionPane.YES_OPTION) return;

processFolder(rootFolder);
// Refresh display
window.albumExplorer.refreshAction.actionPerformed(null);

window.statusBar.setText("Processed " + processCount + " objects");
window.messageBox("Processed " + processCount + " objects");
